/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.block;

import com.minecraftabnormals.neapolitan.common.block.VanillaVineBlock;
import com.minecraftabnormals.neapolitan.core.other.NeapolitanTags;
import com.minecraftabnormals.neapolitan.core.registry.NeapolitanBlocks;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.PlantBlockHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class VanillaVineTopBlock
extends Block
implements IGrowable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)16.0), Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)};

    public VanillaVineTopBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState otherState = worldIn.func_180495_p(pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176734_d()));
        Block block = otherState.func_177230_c();
        return VanillaVineTopBlock.facingSameDirection(state, otherState) || block.func_203417_a(NeapolitanTags.Blocks.VANILLA_PLANTABLE_ON);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b((Property)FACING)).func_176745_a()];
    }

    public static boolean facingSameDirection(BlockState state, BlockState otherState) {
        Block block = otherState.func_177230_c();
        return (block == NeapolitanBlocks.VANILLA_VINE.get() || block == NeapolitanBlocks.VANILLA_VINE_PLANT.get()) && otherState.func_177229_b((Property)FACING) == state.func_177229_b((Property)FACING);
    }

    protected int getGrowthAmount(Random rand) {
        return rand.nextInt(2) + 1;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        super.func_176208_a(world, pos, state, player);
        VanillaVineBlock.createPoisonCloud(world, pos, state, player);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING});
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        BlockPos blockpos;
        if (this.canGrowUp(state, worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos.func_177972_a((Direction)state.func_177229_b((Property)FACING)), (BlockState)worldIn.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b((Property)FACING))), (random.nextDouble() < 0.1 ? 1 : 0) != 0) && this.canGrowIn(worldIn.func_180495_p(blockpos = pos.func_177972_a((Direction)state.func_177229_b((Property)FACING))))) {
            worldIn.func_175656_a(blockpos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)blockpos, (BlockState)worldIn.func_180495_p(blockpos));
        }
    }

    private boolean canGrowUp(BlockState state, ServerWorld world, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        if (Direction.Plane.VERTICAL.test(facing)) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!world.func_180495_p(pos.func_177972_a(direction)).func_200132_m()) continue;
                return true;
            }
        } else {
            for (Direction direction : Direction.Plane.VERTICAL) {
                if (!world.func_180495_p(pos.func_177972_a(direction)).func_200132_m()) continue;
                return true;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (direction.func_176740_k() == Direction.Axis.Y || direction.func_176740_k() == facing.func_176740_k() || !world.func_180495_p(pos.func_177972_a(direction)).func_200132_m()) continue;
                return true;
            }
        }
        return world.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_235714_a_(NeapolitanTags.Blocks.VANILLA_PLANTABLE_ON);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState facingBlock = worldIn.func_180495_p(currentPos.func_177972_a((Direction)stateIn.func_177229_b((Property)FACING)));
        if (facing == ((Direction)stateIn.func_177229_b((Property)FACING)).func_176734_d() && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        if (facingBlock.func_235901_b_((Property)FACING) && facingBlock.func_177229_b((Property)FACING) == stateIn.func_177229_b((Property)FACING) && facingState.func_203425_a((Block)this)) {
            return (BlockState)((Block)NeapolitanBlocks.VANILLA_VINE_PLANT.get()).func_176223_P().func_206870_a((Property)FACING, stateIn.func_177229_b((Property)FACING));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return this.canGrowIn(worldIn.func_180495_p(pos.func_177972_a((Direction)state.func_177229_b((Property)FACING))));
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.func_177972_a((Direction)state.func_177229_b((Property)FACING));
        int j = this.getGrowthAmount(rand);
        for (int k = 0; k < j && this.canGrowIn(worldIn.func_180495_p(blockpos)); ++k) {
            worldIn.func_175656_a(blockpos, state);
            blockpos = blockpos.func_177972_a((Direction)state.func_177229_b((Property)FACING));
        }
    }

    protected boolean canGrowIn(BlockState state) {
        return PlantBlockHelper.func_235514_a_((BlockState)state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l());
    }
}

